function Figure6D
% Running this script produces the plot shown in Figure 6D and
% computes p-values.

%==========================================================================
% Data for different IgM dilutions. First column for each variable is for
% PBS-treated particles. Second column is for osmotically-swollen particles. 
m5C4IgM1to025 = [76.4 83.1 ; 86.8 85.0 ; 62.1 68.6];
m5C4IgM1to050 = [65.1 75.8 ; 55.7 74.1 ; 50.2 58.6 ; 45.9 52.6 ; 76.2 79.4];
m5C4IgM1to100 = [50.0 75.7 ; 31.0 40.2 ; 27.8 40.3 ; 52.4 57.1];
m5C4IgM1to200 = [33.3 58.5 ; 23.2 38.0 ; 14.4 27.7 ; 12.9 26.4 ; 22.2 34.8];
m5C4IgM1to800 = [3.15 6.39 ; 3.47 6.97 ; 3.89 5.57 ; 3.49 5.15];
%==========================================================================

%==========================================================================
% Plot data for replicates and mean:
q = [0 1];
figure; hold on;
plot(q,m5C4IgM1to025,'Color',[.7 .7 .7]); q = q + 1.2;
plot(q,m5C4IgM1to050,'Color',[.7 .7 .7]); q = q + 1.2;
plot(q,m5C4IgM1to100,'Color',[.7 .7 .7]); q = q + 1.2;
plot(q,m5C4IgM1to200,'Color',[.7 .7 .7]); q = q + 1.2;
plot(q,m5C4IgM1to800,'Color',[.7 .7 .7])

mean025 = mean(m5C4IgM1to025);
mean050 = mean(m5C4IgM1to050);
mean100 = mean(m5C4IgM1to100);
mean200 = mean(m5C4IgM1to200);
mean800 = mean(m5C4IgM1to800);

q = [0 1];
plot(q,mean025,'Color',[0 0 0],'LineWidth',1.5); q = q + 1.2;
plot(q,mean050,'Color',[0 0 0],'LineWidth',1.5); q = q + 1.2;
plot(q,mean100,'Color',[0 0 0],'LineWidth',1.5); q = q + 1.2;
plot(q,mean200,'Color',[0 0 0],'LineWidth',1.5); q = q + 1.2;
plot(q,mean800,'Color',[0 0 0],'LineWidth',1.5);
xticks([0.5 1.7 2.9 4.1 5.3]);
xticklabels({'1:25','1:50','1:100','1:200','1:800'});
ylabel('Percent C3-positive particles')
%==========================================================================

%==========================================================================
% Compute p-values using a paired-sample t-test:
[h,p] = ttest(m5C4IgM1to025(:,1),m5C4IgM1to025(:,2));
disp(['p-value for 1:25 comparison: ',num2str(p)]);
[h,p] = ttest(m5C4IgM1to050(:,1),m5C4IgM1to050(:,2));
disp(['p-value for 1:50 comparison: ',num2str(p)]);
[h,p] = ttest(m5C4IgM1to100(:,1),m5C4IgM1to100(:,2));
disp(['p-value for 1:100 comparison: ',num2str(p)]);
[h,p] = ttest(m5C4IgM1to200(:,1),m5C4IgM1to200(:,2));
disp(['p-value for 1:200 comparison: ',num2str(p)]);
[h,p] = ttest(m5C4IgM1to800(:,1),m5C4IgM1to800(:,2));
disp(['p-value for 1:800 comparison: ',num2str(p)]);
%==========================================================================